﻿var importation = {
    datatable: null,
    context: $(".v-importation"),
    previewData: null,
    refreshDataTable: function () {
        importation.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-importationTable", importation.context).a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetTasks", "Importation"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Data": "TaskResultMessage", "Tooltip": true },
                { "Name": "Title", "Title": resources.Name, "Data": "Title" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "DtsType", "Title": resources.DataSourceType, "Data": "DtsTypeDescription" },
                { "Name": "SourceFileName", "Title": resources.FileName, "Data": "SourceFileLabel" },
                { "Name": "TaskStatus", "Title": resources.Status, "Data": "StatusLabel", "type": "enum" },
                { "Name": "LastRunDate", "Title": resources.LastRun, "Data": "LastRunDate", "type": "date", "DefaultValue": resources.NotAvailable },
                { "Name": "CreatedOn", "Title": resources.ModifiedOn, "Data": "CreatedOn" }
            ],
            allowRowSelection: "[ScheduleCount] == 0",
            defaultSorting: { Column: "LastRunDate", Ascending: false },
            toolBarItems: importation.getToolBarItems(),
            stateKey: "ProjectImportation",
            autoUpdate: true,
            contextMenuItems: importation.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var hasSchedule = false;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);

                    if (!hasSchedule && rows[i].ScheduleCount > 0) {
                        hasSchedule = true;
                    }
                }

                switch (action) {
                    case "delete":
                        importation.deleteTasks(ids, hasSchedule);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "stop":
                        importation.stopTask(row.Id);
                        break;
                    case "delete":
                        importation.deleteTasks([row.Id], row.ScheduleCount > 0);
                        break;
                    case "history":
                        importation.importHistory(row.Id);
                        break;
                    case "execute":
                        importation.executeTask(row.Id);
                        break;
                    case "copy":
                        importation.copyTask(row.Id, row.DtsTypeValue);
                        break;
                    case "preview":
                        importation.previewTask(row.Id, row.DtsTypeValue);
                        break;
                    case "view":
                        importation.viewTask(row.Id, row.DtsTypeValue);
                        break;
                    case "edit":
                        importation.editTask(row.Id, row.DtsTypeValue);
                        break;
                    case "sort":
                        importation.sortSample(row.Id);
                        break;
                    case "viewHistory":
                        importation.viewTaskHistory(row.Id, row.Title);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchImportation }
        });
    },
    viewTask: function (itemId, dtsTypeValue) {
        modalDialog.showWindow(a4.getProjectAction("ImportWizard", "Importation", { format: dtsTypeValue, taskId: itemId, readOnly: true }), 700, 950);
    },
    editTask: function (itemId, dtsTypeValue) {
        modalDialog.showWindow(a4.getProjectAction("ImportWizard", "Importation", { format: dtsTypeValue, taskId: itemId }), 700, 950, { afterClose: function () { importation.refreshDataTable(); } });
    },
    copyTask: function (itemId, dtsTypeValue) {
        modalDialog.showWindow(a4.getProjectAction("ImportWizard", "Importation", { format: dtsTypeValue, taskId: itemId, copyTask: true }), 700, 950, { afterClose: function () { importation.refreshDataTable(); } });
    },
    stopTask: function (itemId) {
        a4.callServerMethod(a4.getProjectAction("StopImportation", "Importation"), { taskId: itemId }, function (result) {
            importation.refreshDataTable();
        });
    },
    previewTask: function (itemId, dtsTypeValue) {
        a4.callServerMethod(a4.getProjectAction("GetImportPreviewData", "Importation"), { taskId: itemId }, function (result) {
            importation.previewData = result;
            modalDialog.showWindow(a4.getProjectAction("ImportPreview", "Importation", { taskId: itemId }), 700, 950);
        });
    },
    deleteTasks: function (items, hasSchedule) {
        if (hasSchedule)
        {
            a4.showErrorMessage(resources.DeleteTaskWarning);
        }
        else
        {
            var itemsCount = items.length;

            if (typeof itemsCount === "undefined")
                itemsCount = 1;

            modalDialog.showConfirmDelete(confirmDeleteImportationsResources, function () {
                a4.callServerMethod(a4.getProjectAction("DeleteTasks", "Importation"), { taskIds: items },
                function (result) {
                    importation.refreshDataTable();
                });
            }, itemsCount);
        }
    },
    executeTask: function (itemId) {
        a4.callServerMethod(a4.getProjectAction("StartImportation", "Importation"), { taskId: itemId }, function (result) {
            importation.refreshDataTable();
        });
    },
    viewTaskHistory: function (itemId, itemTitle) {
        modalDialog.showWindow(a4.getProjectAction("TaskHistory", "Tasks", { taskId: itemId, taskTitle: itemTitle }), 600, 1000, { afterClose: function () { } });
    },
    bindEvents: function () {
        var options = { afterClose: function () { importation.refreshDataTable(); } };

        importation.context.on("click", ".h-copyImportationFrom", function () {
            modalDialog.showWindow(a4.getProjectAction("CopyImportationFrom", "Importation"), 600, 800, options);
        });

        importation.context.on("click", ".h-newImportation", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportWizard", "Importation", { format: $(this).attr("data-type") }), 700, 950, options);
        });

        importation.context.on("click", ".h-importHistory", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportHistory", "Importation", { projectId: $("#ProjectId").val() }), 600, 1000);
        });

        importation.context.on("click", ".h-sortSample", function () {
            modalDialog.showWindow(a4.getProjectAction("ImportSortSample", "Importation"), 325, 550);
        });
    },
    getContextMenuItems: function () {
        var isNotRunning = function (data) { return data.Status != 'Running'; };
        return [
            { "Action": "viewHistory", "Label": resources.ViewTaskHistory, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": isNotRunning },
            { "Action": "edit", "Label": resources.Properties, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return data.Status == 'Running'; } },
            { "Action": "execute", "Label": resources.Execute, "DisplayCondition": function (data) { return data.Status != 'Running' && (data.SourceFileName != '' || data.DtsType == 'Case Generator'); } },
            { "Divider": true },
            { "Action": "preview", "Label": resources.PreviewImportation, "DisplayCondition": function (data) { return data.Status != 'Running' && data.SourceFileName != '' && data.DtsType != 'Case Generator'; }},
        ]
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if (importation.context.length > 0) {
        importation.initializeDataTable();
        importation.bindEvents();
    }
});